/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.global;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.picocontainer.Startable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.sonarlint.core.client.api.common.AbstractGlobalConfiguration;

public class GlobalTempFolderProvider
extends ProviderAdapter
implements Startable {
    private static final Logger LOG = Loggers.get(GlobalTempFolderProvider.class);
    private static final long CLEAN_MAX_AGE = TimeUnit.DAYS.toMillis(21L);
    static final String TMP_NAME_PREFIX = ".sonartmp_";
    private DefaultTempFolder tempFolder;

    public TempFolder provide(AbstractGlobalConfiguration globalConfiguration) {
        if (this.tempFolder == null) {
            Path workingPath = globalConfiguration.getWorkDir();
            try {
                GlobalTempFolderProvider.cleanTempFolders(workingPath);
            }
            catch (IOException e) {
                LOG.error(String.format("failed to clean global working directory: %s", workingPath), e);
            }
            Path tempDir = GlobalTempFolderProvider.createTempFolder(workingPath);
            this.tempFolder = new DefaultTempFolder(tempDir.toFile(), true);
        }
        return this.tempFolder;
    }

    private static Path createTempFolder(Path workingPath) {
        try {
            Files.createDirectories(workingPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create working path: " + workingPath, e);
        }
        try {
            return Files.createTempDirectory(workingPath, TMP_NAME_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary folder in " + workingPath, e);
        }
    }

    private static void cleanTempFolders(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, new CleanFilter());){
                for (Path p : stream) {
                    FileUtils.deleteQuietly(p.toFile());
                }
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.tempFolder != null) {
            this.tempFolder.stop();
        }
    }

    private static class CleanFilter
    implements DirectoryStream.Filter<Path> {
        private CleanFilter() {
        }

        @Override
        public boolean accept(Path path) throws IOException {
            BasicFileAttributes attrs;
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            if (!path.getFileName().toString().startsWith(GlobalTempFolderProvider.TMP_NAME_PREFIX)) {
                return false;
            }
            long threshold = System.currentTimeMillis() - CLEAN_MAX_AGE;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.error(String.format("Couldn't read file attributes for %s : ", path), ioe);
                return false;
            }
            long creationTime = attrs.creationTime().toMillis();
            return creationTime < threshold;
        }
    }
}

